(function(){

function fwurgHeaderSwitchboxToggle() {
	var box = document.getElementById('switchbox');
	if(box.style.display != 'block') {
		box.style.display = 'block';
		var search = document.getElementById('accountSearch');
		if(typeof search != 'undefined') {
			searchAccounts('');
			search.value = '';
			search.focus();
		}
	} else {
		box.style.display = 'none';
	}
}

function searchAccounts(fragment, event) {
	var switchbox = document.getElementById('switchbox');
	var rows = switchbox.querySelectorAll('tr');

	var lastSelected = null;

	// handle filtering
	if(fragment == '') {
		// no fragment
		switchbox.classList.remove('filtered');
		for(var i = 0; i < rows.length; i++) {
			rows.item(i).classList.remove('selected');
		}
	} else {
		switchbox.classList.add('filtered');

		var visibleMembers = 0;

		for(var i = rows.length-1; i > 0; i--) {
			var row = rows.item(i);

			// always select the search row
			if(row.classList.contains('search')) row.add('selected');

			// test each account
			if(row.classList.contains('account')) {
				// select all matching accounts (try regex for nerdiness)
				var match = null;
				try {
                    var re = new RegExp(fragment, 'i');
					match = (row.querySelector('div.relevant').textContent.trim().match(re) != null);
                    match |= (row.querySelector('div.irrelevant').textContent.trim().match(re) != null);
				} catch(e) {
					match =	(row.querySelector('div.relevant').textContent.toLowerCase().indexOf(fragment.toLowerCase()) >= 0);
					match |=	(row.querySelector('div.irrelevant').textContent.toLowerCase().indexOf(fragment.toLowerCase()) >= 0);
				}
				if(match) {
					row.classList.add('selected');
					lastSelected = row;
					visibleMembers++;
				} else {
					row.classList.remove('selected');
				}
			}

			if(row.classList.contains('header')) {
				if(visibleMembers > 0) {
					row.classList.add('selected');
				} else {
					row.classList.remove('selected');
				}
				visibleMembers = 0;
			}
		}
	}

	// handle actual special keys
	if(typeof event != 'undefined') {
		switch(event.keyCode) {
			case 27: //escape
				fwurgHeaderSwitchboxToggle();
				break;
			case 13: //return
				if(lastSelected != null) {
					window.location = lastSelected.querySelector('a').getAttribute('href');
				}
				break;
		}
	}

}

switchbox = {
	toggle: fwurgHeaderSwitchboxToggle,
	search: searchAccounts
}

})();
