(function($) {

/**
 * Disables the widget. Multiplexes to all widgets with this id.
 */
var disableWidget = function($widget) {
	var topic = $widget.attr('data-thread');
	var $widgets = $('.openWidget[data-thread='+topic+']');

	$widgets.each(function(_,widget) {
		var $widget = $(widget);
		$widget.toggleClass('disabled',true);
	});
}

/**
 * Updates the widget's state. Multiplexes to all widgets with this id.
 */
var updateWidget = function($widget, state) {
	var topic = $widget.attr('data-thread');
	var $widgets = $('.openWidget[data-thread='+topic+']');

	var open = state.status.indexOf('open') != -1;

	if(state.status.length > 0) {
		var $tag = $('.tags .tag-status');
		var $el = $("<span class='tag-status'>" + state.status.join(', ') + "</span>");
		if($tag.length) {
			$tag.replaceWith($el);
		} else {
			$('.tags').append($el);
		}
	} else {
		$('.tags .tag-status').remove();
	}

	$widgets.each(function(_,widget) {
	  var $widget = $(widget);

		// clear out widget state
		$widget.toggleClass('open', open);

		// set classes depending on state
		if(open) {
			$widget.text('Mark as Done');
			$widget.attr('title','This thread is currently open. Click to close.');
		} else {
			$widget.text('Mark as Open');
			$widget.attr('title','This thread is currently done. Click to open.');
		}

		// enable the widget
		$widget.toggleClass('disabled', false);
	});
}

/**
 * Performs a request to the backend, followed by an update of the widget.
 */
var requestThenUpdate = function($widget, params) {
	// disable the widget
	disableWidget($widget);

	// do the request
	return $.get('/tools/open/update',
		params,
		function(reply) { updateWidget($widget,reply); },
		'json'
	);
}

var net = {
	open: function($widget, type) {
		requestThenUpdate($widget, {
			op:'open',
			thread:$widget.attr('data-thread')
		});
	},
	
	close: function($widget) {
		requestThenUpdate($widget,{
			op:'close',
			thread:$widget.attr('data-thread')
		});
	},
	
	update: function($widget) {
		requestThenUpdate($widget,{
			op: 'status',
			thread:$widget.attr('data-thread')
		});
	}
}

// initialize follow widgets
$(document).ready(function() {
	// keeps a list of topic IDs already initialized
	var seen = {};

	$('.openWidget').each(function(_,widget) {
		// the widget
		var $widget = $(widget);

		// skip already seen ids
		if($widget.attr('data-thread') in seen) return;
		seen[$widget.attr('data-thread')] = true;

		// fire the update
		net.update($widget);
	});

	$('.openWidget').click(function() {
		var $widget = $(this).closest('.openWidget');

		// prevent action when disabled
		if($widget.hasClass('disabled')) return;

		if($widget.hasClass('open')) {
			net.close($widget);
		} else {
			net.open($widget);
		}
	});
});

})(jQuery);
