(function($) {

function createLinks(links) {
	var result = [];
	
	// sort links
	links.sort(function(a,b) {
		return (a.title < b.title) ? -1 : ((a.title > b.title) ? 1 : 0 );
	});

	$.each(links, function(_,link) {
		result.push("<a href='" + link.link + "'>" + ($('<div/>').text(link.title).html()) + "</a>");
	});

	return result;
}

function updateRelatedStories($widget, links) {
	// update topic-wide stories
	var result = createLinks(links.related);

	var $span = $('span',$widget);
	$widget.removeClass("loading");
	$span.empty();

	if(result.length != 0) {
		$widget.addClass("links");
		$span.append(result.join(", "));
	} else {
		$widget.addClass("nolinks");
		$span.append("None");
	}

	$('span.postRelatedStories').each(function(_,post) {
		var postLinks = links.posts[$(post).attr('data-post')];
		if(typeof postLinks != 'undefined') {
			var result = createLinks(postLinks);
			if(result.length) $(post).append("(Related pages: " + result.join(", ") + ")");
		}
	});
}

// initialize follow widgets
$(document).ready(function() {
	$('.relatedStories').each(function(_,widget) {
		$.get('/tools/related-stories',{thread:$(widget).attr('data-thread')},
			function(reply) {
				updateRelatedStories($(widget), reply);
			},
			'json');
	});
});

})(jQuery);
