﻿// This file contains the Jedi details

function raiseForceLevel() {
	var forceLevel = jedi.getForceLevel();
	forceLevel += 1;
	if(forceLevel >= 10) {
		jedi.setForceLevel(10);
	} else {
		jedi.setForceLevel(forceLevel);
	}
}

function lowerForceLevel() {
	var forceLevel = jedi.getForceLevel();
	forceLevel -= 1;
	if(forceLevel <= 0) {
		jedi.setForceLevel(0);
	} else {
		jedi.setForceLevel(forceLevel);
	}
}

function raiseAttribute(attribute) {
	var attributeValue = jedi.getAttribute(attribute);
	attributeValue += 1;
	if(attributeValue >= 10) {
		jedi.setAttribute(attribute, 10);
	} else {
		jedi.setAttribute(attribute, attributeValue);
	}
}

function lowerAttribute(attribute) {
	var attributeValue = jedi.getAttribute(attribute);
	attributeValue -= 1;
	if(attributeValue <= 1) {
		jedi.setAttribute(attribute, 1);
	} else {
		jedi.setAttribute(attribute, attributeValue);
	}
}


function fillAttribute(jedi, attribute) {
	var html = "";
	for(var i = 0; i < 10; i++) {
		if(i%5 == 0) {
			html += ' ';
		}
		html += '<span onclick="jedi.setAttribute(\'' + attribute + '\', ' + (i+1) + '); fillAttribute(jedi, \'' + attribute + '\');" style="font-size:18px;">'
		html += (i < jedi.getAttribute(attribute) ? '●' : '○');
		html +='</span>';
	}
	
	if(jedi.getAttribute(attribute) <= 1) {
		$('#' + attribute + 'Minus').addClass('disabled');
	} else {
		$('#' + attribute + 'Minus').removeClass('disabled');
	}

	if(jedi.getAttribute(attribute) >= 10) {
		$('#' + attribute + 'Plus').addClass('disabled');
	} else {
		$('#' + attribute + 'Plus').removeClass('disabled');
	}
	
	
	$('#' + attribute + 'entry').html(html);
}

function fillForceLevel(jedi) {
	var html = "";
	for(var i = 0; i < 10; i++) {
		if(i%5 == 0) {
			html += ' ';
		}
		html += '<span onclick="jedi.setForceLevel(' + (i+1) + '); fillForceLevel(jedi);" style="font-size:18px;">'
		html += (i < jedi.getForceLevel() ? '●' : '○');
		html +='</span>';
	}
	
	if(jedi.getForceLevel() <= 0) {
		$('#forceLevelMinus').addClass('disabled');
	} else {
		$('#forceLevelMinus').removeClass('disabled');
	}

	if(jedi.getForceLevel() >= 10) {
		$('#forceLevelPlus').addClass('disabled');
	} else {
		$('#forceLevelPlus').removeClass('disabled');
	}
	
	$('#forcelevelentry').html(html);
	$('#forcerank').text(jedi.getForceRank());
}

function addForcePower(title, description) {
	var html = '<tr><td style="width:302px;"><a target="_blank" href="/dokuwiki/rules:' + title + '" title="' + description + '">' + title + '</a><span class="emptyBox" onclick="jedi.setForcePowerLevel(\'' + title + '\', 0);fillForcePower(\'' + title + '\')"></span></td><td style="width:43px;" id=\'FP_' + replaceAll(title,' ', '_') + '\'></td><td class="plusMinusBlock"><img id="FP_' + replaceAll(title,' ', '_') + 'Plus" style="cursor:pointer;" src="plus.png" title="+1" onclick="raiseForcePower(\'' +title + '\');"/><img id="FP_' + replaceAll(title,' ', '_') + 'Minus" onclick="lowerForcePower(\'' +title + '\');" src="minus.png" style="cursor:pointer;" title="-1" /></td></tr>';
	$('#forcepowers').append(html);
	fillForcePower(title);
}

function fillForcePower(title) {
	var html = '';
	for(var i = 0; i < 3; i++) {
		html += '<span onclick="jedi.setForcePowerLevel(\'' + title + '\', ' + (i+1) + ');fillForcePower(\'' + title + '\')" style="font-size:18px;">'
		html += (i < jedi.getForcePowerLevel(title) ? '●' : '○');
		html +='</span>';
	}
	
	if(jedi.getForcePowerLevel(title) <= 0) {
		$('#FP_' + replaceAll(title,' ', '_') + 'Minus').addClass('disabled');
	} else {
		$('#FP_' + replaceAll(title,' ', '_') + 'Minus').removeClass('disabled');
	}

	if(jedi.getForcePowerLevel(title) >= 3) {
		$('#FP_' + replaceAll(title,' ', '_') + 'Plus').addClass('disabled');
	} else {
		$('#FP_' + replaceAll(title,' ', '_') + 'Plus').removeClass('disabled');
	}
	
	$('#FP_' + replaceAll(title, ' ', '_')).html(html);
}

function raiseForcePower(title) {
	
	var forceLevel = jedi.getForcePowerLevel(title);
	forceLevel += 1;
	if(forceLevel >= 3) {
		jedi.setForcePowerLevel(title, 3);
	} else {
		jedi.setForcePowerLevel(title, forceLevel);
	}
	fillForcePower(title);
}

function lowerForcePower(title) {
	var forceLevel = jedi.getForcePowerLevel(title);
	forceLevel -= 1;
	if(forceLevel <= 0) {
		jedi.setForcePowerLevel(title, 0);
	} else {
		jedi.setForcePowerLevel(title, forceLevel);
	}
	fillForcePower(title);
}

function addSkill(title, description) {
	var html = '<tr><td class="titleBlock"><a target="_blank" href="/dokuwiki/rules:' + title + '_skill" title="' + description + '">' + title + '</a><span class="emptyBox" onclick="jedi.setSkillLevel(\'' + title + '\', 0);fillSkill(\'' + title + '\')"></span></td><td style="width:120px;" id=\'SK_' + replaceAll(title, ' ', '_') + '\'></td><td class="plusMinusBlock"><img onclick="raiseSkill(\'' + title + '\');" id=\'SK_' + replaceAll(title, ' ', '_') + 'Plus\' style="cursor:pointer;" src="plus.png" title="+1" /><img onclick="lowerSkill(\'' + title + '\');" id=\'SK_' + replaceAll(title, ' ', '_') + 'Minus\' src="minus.png" style="cursor:pointer;" title="-1" /></td></tr>';
	
	$('#skills').append(html);
	fillSkill(title);
}

function raiseSkill(title) {
	var skillLevel = jedi.getSkillLevel(title);
	skillLevel += 1;
	if(skillLevel >= 10) {
		jedi.setSkillLevel(title, 10);
	} else {
		jedi.setSkillLevel(title, skillLevel);
	}
	fillSkill(title);
}

function lowerSkill(title) {
	var skillLevel = jedi.getSkillLevel(title);
	skillLevel -= 1;
	if(skillLevel <= 0) {
		jedi.setSkillLevel(title, 0);
	} else {
		jedi.setSkillLevel(title, skillLevel);
	}
	fillSkill(title);
}


function fillSkill(title) {
	var html = '';
	for(var i = 0; i < 10; i++) {
		if(i%5 == 0) {
			html += ' ';
		}
		html += '<span onclick="jedi.setSkillLevel(\'' + title + '\', ' + (i+1) + ');fillSkill(\'' + title + '\');" style="font-size:18px;">'
		html += (i < jedi.getSkillLevel(title) ? '●' : '○');
		html +='</span>';
	}
	if(jedi.getSkillLevel(title) <= 0) {
		$('#SK_' + replaceAll(title,' ', '_') + 'Minus').addClass('disabled');
	} else {
		$('#SK_' + replaceAll(title,' ', '_') + 'Minus').removeClass('disabled');
	}

	if(jedi.getSkillLevel(title) >= 10) {
		$('#SK_' + replaceAll(title,' ', '_') + 'Plus').addClass('disabled');
	} else {
		$('#SK_' + replaceAll(title,' ', '_') + 'Plus').removeClass('disabled');
	}
	
	
	$('#SK_' + replaceAll(title, ' ', '_')).html(html);
}

function addStyle(title, styleId, wiki, description) {
	var html = '<tr><td><a target="_blank" href="/dokuwiki/rules:' + title + '" title="' + description +'">' + title + '</a><span onclick="jedi.toggleStyle(\'' + title + '\');fillStyle(\'' + title + '\');"></span></td><td onclick="jedi.toggleStyle(\'' + title + '\');fillStyle(\'' + title + '\');" style="cursor:pointer;text-align:center;" id=\'ST_' + replaceAll(title,' ', '_') + '\'></td></tr>';
	var qb = wiki.qb();
	wiki.queryResources(qb.query(
		qb.fields('?m', '?d'), qb.where('?m is a: combat_style_manoeuvre','?m Description[wiki]: ?d', '?m Combat Style[ref]: '+styleId)
	)).then(function(data) {
		var manoeuvres = data.body;
		var sortedManoeuvres = new Array();
		var sortedManDesc = new Array();
		for(var manoeuvreindex in manoeuvres) {
			sortedManoeuvres[manoeuvreindex] = manoeuvres[manoeuvreindex]['entry title'][0];
			sortedManDesc[manoeuvreindex] = manoeuvres[manoeuvreindex]['Description'][0]
		}
		sortedManoeuvres.sort();
		for(var manoeuvreindex in sortedManoeuvres) {
			html += addManoeuvre(title, sortedManoeuvres[manoeuvreindex], sortedManDesc[manoeuvreindex]);
		}		
		$('#styles').append(html);
		combatStyles[title] = sortedManoeuvres;
		fillStyle(title);
	});	
}

var combatStyles = new Array();

function addManoeuvre(style, manoeuvre, description) {
	var html = '';
	html += '</td></tr><tr><td style="padding-left:20px;"><a class="notalink" title="' + description + '">' + manoeuvre + '</a></td><td onclick="jedi.toggleManoeuvre(\'' + style + "', '" + manoeuvre + '\');fillManoeuvre(\'' + style + "', '" + manoeuvre + '\');" style="cursor:pointer;text-align:center;" id=\'STM_' + replaceAll(style,' ', '_') + "_" + replaceAll(manoeuvre, ' ', '_') + '\'></td>';
	html += '</tr>'
	return html;
}

function fillManoeuvre(style, manoeuvre) {
	var html = '';
		html += (jedi.hasManoeuvre(style, manoeuvre) ? '<span style="font-size:18px;">●</span>' : '<span style="font-size:18px;">○</span>');
	$('#STM_' + replaceAll(style, ' ', '_') + "_" + replaceAll(manoeuvre, ' ', '_')).html(html); 
}

function fillStyle(title) {
	var html = '';
		html += (jedi.hasStyle(title) ? '<span style="font-size:18px;">●</span>' : '<span style="font-size:18px;">○</span>');
	$('#ST_' + replaceAll(title, ' ', '_')).html(html);
	for(var manoeuvreindex in combatStyles[title]) {
		fillManoeuvre(title, combatStyles[title][manoeuvreindex]);
		if(jedi.hasStyle(title)) {
			$('#STM_' + replaceAll(title, ' ', '_') + "_" + replaceAll(combatStyles[title][manoeuvreindex], ' ', '_')).parent().removeClass('disabled');
		} else {
			$('#STM_' + replaceAll(title, ' ', '_') + "_" + replaceAll(combatStyles[title][manoeuvreindex], ' ', '_')).parent().addClass('disabled');
		}
	}
}



$(function() {
	fillForceLevel(jedi);
	fillAttribute(jedi, "Fitness");
	fillAttribute(jedi, "Vision");
	fillAttribute(jedi, "Strength");
	fillAttribute(jedi, "Reason");
	fillAttribute(jedi, "Intuition");
	fillAttribute(jedi, "Energy");

	var wiki = new fwurg.Wiki();
	var qb = wiki.qb();

	wiki.queryResources(qb.query(
		qb.fields('?p', '?d'), qb.where(
			'?p is a: force_power', 
			'?p Description[wiki]: ?d',
			'?p Caption: Power',			
			'minus {',
			'  ?w is a: wip',
			'  ?w Page[ref]: ?p',
			'}',
			'minus {',
			'  ?u is a: unvalidated',
			'  ?u Page[ref]: ?p',
			'}'
))).then(function(data) {
		var forcepowers = data.body;
		var sortedPowers = new Array();
		var sortedDescriptions = new Array();
		for(var k in forcepowers) {
			sortedPowers[k] = forcepowers[k]['entry title'][0];
			sortedDescriptions[k] = forcepowers[k]['Description'][0];
		}
		sortedPowers.sort();
		for(var k in sortedPowers) {
			addForcePower(sortedPowers[k], sortedDescriptions[k]);
		}
		
	});

	wiki.queryResources(qb.query(
		qb.fields('?s', '?d'), qb.where(
			'?s is a: skill',
			'?s Description[wiki]: ?d',
			'minus {',
			'  ?w is a: wip',
			'  ?w Page[ref]: ?s',
			'}',
			'minus {',
			'  ?u is a: unvalidated',
			'  ?u Page[ref]: ?s',
			'}'
))).then(function(data) {
		var skills = data.body;
		var sortedSkills = new Array();
		var sortedDescriptions = new Array();
		for(var skillindex in skills) {
			sortedSkills[skillindex] = skills[skillindex]['entry title'][0];
			sortedDescriptions[skillindex] = skills[skillindex]['Description'][0];
		}
		sortedSkills.sort();
		for(var skillIndex in sortedSkills) {
			addSkill(sortedSkills[skillIndex], sortedDescriptions[skillIndex]);
		}
	});	

	wiki.queryResources(qb.query(
		qb.fields('?cs', '?d'), qb.where(
			'?cs is a: combat_style',
			'?cs Description[wiki]: ?d',
			'minus {',
			'  ?w is a: wip',
			'  ?w Page[ref]: ?cs',
			'}',
			'minus {',
			'  ?u is a: unvalidated',
			'  ?u Page[ref]: ?cs',
			'}'
))).then(function(data) {
		var styles = data.body;
		var sortedStyles = new Array();
		var sortedDescriptions = new Array();
		for(var styleindex in styles) {
			sortedStyles[styleindex] = styles[styleindex]['entry title'][0];
			sortedDescriptions[styleindex] = styles[styleindex]['Description'][0];
		}
		sortedStyles.sort();
		for(var styleIndex in sortedStyles) {
			addStyle(sortedStyles[styleIndex], styleIndex, wiki, sortedDescriptions[styleIndex]);
		}
	});	
	
})
