// This file contains the lightsaber details

var saber;

$(function () {
	saber = new Saber();

	// initialise regular saber size buttons
	$("#sabersizeRegular div.select").click(function() {
		if(! $(this).hasClass("disabled")) {
			// select this box and not the others in the set
			$(this).addClass("selected").siblings().removeClass("selected");
			// show the left blade, remove the five blade length classes from this saber and add the new blade length class (don't remove all classes or we lose the colour class
			$('#leftBlade').removeClass('none').removeClass('dagger').removeClass('short').removeClass('regular').removeClass('long').addClass($(this).data('bladelength'));
			saber.setBladeType($(this).data('bladelength'));
			disableHandleSelectors();
		}
	});
	
	// initialise saberstaff size buttons
	$("#sabersizeStaff div.select").click(function() {
		$(this).addClass("selected").siblings().removeClass("selected");
		$('#leftBlade').removeClass('none').removeClass('dagger').removeClass('short').removeClass('regular').removeClass('long').addClass($(this).data('bladelength'));
		$('#rightBlade').removeClass('none').removeClass('dagger').removeClass('short').removeClass('regular').removeClass('long').addClass($(this).data('bladelength'));
		saber.setBladeType($(this).data('bladelength'));
		disableHandleSelectors();
	});

	// initialise dual wield size buttons
	$("#sabersizeDual div.select").click(function() {
		if(! $(this).hasClass("disabled")) {
			// select this box and not the others in the set
			$(this).addClass("selected").siblings().removeClass("selected");
			$('#leftBlade').removeClass('none').removeClass('dagger').removeClass('short').removeClass('regular').removeClass('long').addClass($(this).data('leftbladelength'));
			$('#rightBlade').removeClass('none').removeClass('dagger').removeClass('short').removeClass('regular').removeClass('long').addClass($(this).data('rightbladelength'));
			saber.setBladeType($(this).data('leftbladelength'));
			saber.setOtherBladeType($(this).data('rightbladelength'));
			disableHandleSelectors();
		}
	});

	// initialise handle buttons
	$("#saberhandle div.select").click(function() {
		if(! $(this).hasClass("disabled")) {
			// select this box and not the others in the set
			$(this).addClass("selected").siblings().removeClass("selected");
			$('#leftHandle').removeClass('shortHandle').removeClass('regularHandle').removeClass('longHandle').removeClass('curvedHandle').removeClass('tonfaHandle').removeClass('crossguardHandle').removeClass('forcePike').addClass($(this).data('handletype'));
			$('#rightHandle').removeClass('shortHandle').removeClass('regularHandle').removeClass('longHandle').removeClass('curvedHandle').removeClass('tonfaHandle').removeClass('crossguardHandle').removeClass('forcePike').addClass($(this).data('handletype'));
			saber.setHandleType($(this).data('handletype'));
		}
	}).filter(':first').click();
	
	// initialise colour buttons and click first (blue)
	$("#mainsabercolour div.selectColour").click(function() {
		// select this box and not the others in the set
		$(this).addClass("selected").siblings().removeClass("selected");
		// show the left blade, remove the five blade length classes from this saber and add the new blade length class (don't remove all classes or we lose the colour class
		$('#leftSaber').removeClass('red').removeClass('yellow').removeClass('green').removeClass('purple').removeClass('blue').addClass($(this).data('colour'));
		saber.setBladeColour($(this).data('colour'));
	}).filter(':first').click();

	// initialise colour buttons and click first (blue)
	$("#othersabercolour div.selectColour").click(function() {
		// select this box and not the others in the set
		$(this).addClass("selected").siblings().removeClass("selected");
		// show the left blade, remove the five blade length classes from this saber and add the new blade length class (don't remove all classes or we lose the colour class
		$('#rightSaber').removeClass('red').removeClass('yellow').removeClass('green').removeClass('purple').removeClass('blue').addClass($(this).data('colour'));
		saber.setOtherBladeColour($(this).data('colour'));
	}).filter(':first').click();
	
	$('#singleSaber').click(function() {
		$("#sabersizeRegular").show();
		$("#sabersizeStaff").hide();
		$("#sabersizeDual").hide();
		$("#rightHandle").hide();
		$("#rightBlade").removeClass("dual").hide();
		$("#leftHandle").removeClass("dual");
		saber.setWeaponType('single saber');
		$('#sabersizeRegular .select').filter(function() {
			return $(this).data("bladelength") === saber.getBladeType();
		}).click();		
		disableHandleSelectors();
		$("#othersabercolour").hide();
	});
	$('#saberStaff').click(function() {
		$("#sabersizeRegular").hide();
		$("#sabersizeStaff").show();
		$("#sabersizeDual").hide();
		$("#leftHandle").addClass("dual");
		$("#rightHandle").hide();
		$("#rightBlade").addClass("dual").show();
		saber.setWeaponType('saberstaff');
		if(saber.getBladeType() == 'dagger') {
			saber.setBladeType('short');
		} else if(saber.getBladeType() == 'long') {
			saber.setBladeType('regular');
		}
		saber.setOtherBladeType(saber.getBladeType());
		$('#sabersizeStaff .select').filter(function() {
			return $(this).data("bladelength") === saber.getBladeType();
		}).click();		
		disableHandleSelectors();
		$("#othersabercolour").show();
	});
	$('#dualSaber').click(function() {
		$("#sabersizeRegular").hide();
		$("#sabersizeStaff").hide();
		$("#sabersizeDual").show();
		$('#rightHandle').show();
		$('#rightBlade').show().removeClass("dual");
		$("#leftHandle").removeClass("dual");
		saber.setWeaponType('dual sabers');
		
		if(saber.getBladeType() == 'long') {
			saber.setBladeType('regular');
		}

		$('#sabersizeDual .select').filter(function() {
			return ($(this).data("leftbladelength") == saber.getBladeType()) && ($(this).data("rightbladelength") == saber.getOtherBladeType());
		}).click();		

		disableHandleSelectors();
		$("#othersabercolour").show();
	});

	$("#saberStyle div.select").click(function() {
		$(this).addClass("selected").siblings().removeClass("selected");
	}).filter(':first').click();
	
});

/**
 * Adjust the blade length of either the left or the right blade. 
 */
function disableHandleSelectors() {
	// regular: always on
	$('#regularHandleSelector').removeClass('disabled');
	
	// short handle: disable for saberstaff, long blade
	if((saber.getWeaponType() == 'saberstaff') || (saber.getBladeType() == 'long')) {
		$('#shortHandleSelector').addClass('disabled');
	} else {
		$('#shortHandleSelector').removeClass('disabled');
	}

	// long handle: disable for dual sabers
	if((saber.getWeaponType() == 'dual sabers') || saber.getBladeType() == 'dagger' || ((saber.getBladeType() == 'short') && (saber.getWeaponType() != 'saberstaff'))) {
		$('#longHandleSelector').addClass('disabled');
	} else {
		$('#longHandleSelector').removeClass('disabled');
	}

	// curved handle: disable for saberstaff, long blade, regular blade
	if((saber.getWeaponType() == 'saberstaff') || (saber.getBladeType() == 'long') || (saber.getBladeType() == 'regular') ) {
		$('#curvedHandleSelector').addClass('disabled');
	} else {
		$('#curvedHandleSelector').removeClass('disabled');
	}
	
	// crossguard handle: disable for saberstaff, long blade, regular blade
	if((saber.getWeaponType() == 'saberstaff') || (saber.getBladeType() == 'long') || (saber.getBladeType() == 'regular') ) {
		$('#crossguardHandleSelector').addClass('disabled');
	} else {
		$('#crossguardHandleSelector').removeClass('disabled');
	}
	
	// tonfa: disable for saberstaff, long blade
	if((saber.getWeaponType() == 'saberstaff') || (saber.getBladeType() == 'long') ) {
		$('#tonfaHandleSelector').addClass('disabled');
	} else {
		$('#tonfaHandleSelector').removeClass('disabled');
	}
	
	// force pike: disable for saberstaff, dual wield, anything but dagger length blade
	if((saber.getWeaponType() == 'single saber') && (saber.getBladeType() == 'dagger')) {
		$('#forcePikeSelector').removeClass('disabled');
	} else {
		$('#forcePikeSelector').addClass('disabled');
	}

	// select a legal handle (regular) if the handle was illegal
	if($('#saberhandle .selected').hasClass('disabled')) {
		$('#regularHandleSelector').click();
	}
}

function Saber() {
	this.weaponType = 'single saber';
	this.bladeType = 'regular';
	this.otherBladeType = 'regular';
	this.handleType = 'regularHandle';
	this.bladeColour = 'blue';
	this.otherBladeColour = 'blue';

	this.setWeaponType = function(newType) {
		this.weaponType = newType.replace(/^\s\s*/, '').replace(/\s\s*$/, '');

		this.updateOverview();
	}
	
	this.getWeaponType = function() {
		return this.weaponType;
	}
	
	this.setBladeType = function(newType) {
		this.bladeType = newType.replace(/^\s\s*/, '').replace(/\s\s*$/, '');
		if(newType == 'short' && this.otherBladeType == 'regular') {
			this.setOtherBladeType('short');
		} else if(newType == 'dagger' && this.otherBladeType == 'regular') {
			this.setOtherBladeType('dagger');
		} else if(newType == 'dagger' && this.otherBladeType == 'short') {
			this.setOtherBladeType('dagger');
		}
		
		this.updateOverview();
	}

	this.getBladeType = function() {
		return this.bladeType;
	}
	
	this.setOtherBladeType = function(newType) {
		this.otherBladeType = newType.replace(/^\s\s*/, '').replace(/\s\s*$/, '');

		this.updateOverview();
	}

	this.getOtherBladeType = function() {
		return this.otherBladeType;
	}

	this.setHandleType = function(newType) {
		this.handleType = newType.replace(/^\s\s*/, '').replace(/\s\s*$/, '');

		this.updateOverview();
	}

	this.getHandleType = function() {
		return this.handleType;
	}
	
	this.getHandleTypeString = function() {
		if(this.handleType == 'shortHandle') {
			return "short handle";
		} else if(this.handleType == 'regularHandle') {
			return "regular handle";
		} else if(this.handleType == 'longHandle') {
			return "long handle";
		} else if(this.handleType == 'curvedHandle') {
			return "curved handle";
		} else if(this.handleType == 'tonfaHandle') {
			return "tonfa handle";
		} else if(this.handleType == 'crossguardHandle') {
			return "crossguard handle";
		} else if(this.handleType == 'forcePike') {
			return "force pike";
		}

	}
	
	this.setBladeColour = function(newColour) {
		this.bladeColour = newColour.replace(/^\s\s*/, '').replace(/\s\s*$/, '');

		this.updateOverview();
	}
	
	this.getBladeColour = function() {
		return this.bladeColour;
	}

	this.setOtherBladeColour = function(newColour) {
		this.otherBladeColour = newColour.replace(/^\s\s*/, '').replace(/\s\s*$/, '');

		this.updateOverview();
	}
	
	this.getOtherBladeColour = function() {
		return this.otherBladeColour;
	}

	this.toString = function() {
		return 	"Weapon type: '" + this.weaponType + "'\n" +
				"Blade type: '" + this.bladeType + "'\n" +
				"Other Blade type: '" + this.otherBladeType + "'\n" +
				"Handle type: '" + this.handleType + "'\n"
	}
	
	this.toWikiString = function() {
		var wiki = "<data !lightsaber #Lightsaber>\n";
		   wiki += "Character_ref    : [[]]\n";
		   
		   wiki += "Hilt             : ";
			if(this.getWeaponType() == 'dual sabers') {
				wiki += "two "
			}
		   wiki += this.getHandleTypeString();
			if(this.getWeaponType() == 'dual sabers') {
				wiki += "s"
			}
		   wiki += "\n";
		   
		   wiki += "Usage            : " + this.getUsage() + "\n";
		   
		   wiki += "Blade            : ";
			if(this.getWeaponType() == 'dual sabers' && this.getBladeType() != this.getOtherBladeType()) {
				wiki += this.getBladeType() + " blade, " + this.getOtherBladeType() + " blade\n";
			} else if(this.getWeaponType() == 'dual sabers') {
				wiki += "two " + this.getBladeType() + " blades\n";
			} else {
				wiki += this.getBladeType() + " blade\n";
			}
		   
		   wiki += "Colour           : " + this.getBladeColour();
			if(this.getWeaponType() == 'dual sabers' && this.getBladeColour() != this.getOtherBladeColour()) {
				wiki += ", " + this.getOtherBladeColour()
			}
		   wiki += "\n";
		   
		   wiki += "Slashing [dot]     : " + this.getSlashing() + "\n";
		   wiki += "Cutting [dot]      : " + this.getCutting() + "\n";
		   wiki += "Piercing [dot]     : " + this.getPiercing() + "\n";
		   wiki += "Dodging [dot]      : " + this.getDodging() + "\n";
		   wiki += "Blocking [dot]     : " + this.getBlocking() + "\n";
		   wiki += "Deflecting [dot]   : " + this.getDeflecting() + "\n";
		   wiki += "</data>";
	
		return wiki;
	}
	
	this.getSlashing = function() {
		if(this.getWeaponType() == 'dual sabers') {
			if(this.bladeType == 'regular' && this.otherBladeType == 'regular') {
				return "2";
			} else if(this.bladeType == 'regular' && this.otherBladeType == 'short') {
				return "2";
			} else if(this.bladeType == 'regular' && this.otherBladeType == 'dagger') {
				return "2";
			} else if(this.bladeType == 'short' && this.otherBladeType == 'short') {
				return "1";
			} else if(this.bladeType == 'short' && this.otherBladeType == 'dagger') {
				return "0";
			} else if(this.bladeType == 'dagger' && this.otherBladeType == 'dagger') {
				return "1";
			}
		} else if(this.getWeaponType() == 'saberstaff') {
			if(this.bladeType == 'regular') {
				return "4";
			} else if(this.bladeType == 'short') {
				return "0";
			}
		} else if(this.getWeaponType() == 'single saber'){
			if(this.bladeType == 'long') {
				return "3";
			} else if(this.bladeType == 'regular') {
				return "1";
			} else if(this.bladeType == 'short') {
				return "0";
			} else if(this.bladeType == 'dagger') {
				return "0";
			}
		}
		return "ERROR";
	}
	this.getCutting = function() {
		if(this.getWeaponType() == 'dual sabers') {
			if(this.bladeType == 'regular' && this.otherBladeType == 'regular') {
				return "1";
			} else if(this.bladeType == 'regular' && this.otherBladeType == 'short') {
				return "2";
			} else if(this.bladeType == 'regular' && this.otherBladeType == 'dagger') {
				return "0";
			} else if(this.bladeType == 'short' && this.otherBladeType == 'short') {
				return "2";
			} else if(this.bladeType == 'short' && this.otherBladeType == 'dagger') {
				return "2";
			} else if(this.bladeType == 'dagger' && this.otherBladeType == 'dagger') {
				return "1";
			}
		} else if(this.getWeaponType() == 'saberstaff') {
			if(this.bladeType == 'regular') {
				return "0";
			} else if(this.bladeType == 'short') {
				return "4";
			}
		} else if(this.getWeaponType() == 'single saber'){
			if(this.bladeType == 'long') {
				return "1";
			} else if(this.bladeType == 'regular') {
				return "3";
			} else if(this.bladeType == 'short') {
				return "3";
			} else if(this.bladeType == 'dagger') {
				return "1";
			}
		}
		return "ERROR";
	}
	this.getPiercing = function() {
		if(this.getWeaponType() == 'dual sabers') {
			if(this.bladeType == 'regular' && this.otherBladeType == 'regular') {
				return "1";
			} else if(this.bladeType == 'regular' && this.otherBladeType == 'short') {
				return "0";
			} else if(this.bladeType == 'regular' && this.otherBladeType == 'dagger') {
				return "2";
			} else if(this.bladeType == 'short' && this.otherBladeType == 'short') {
				return "1";
			} else if(this.bladeType == 'short' && this.otherBladeType == 'dagger') {
				return "2";
			} else if(this.bladeType == 'dagger' && this.otherBladeType == 'dagger') {
				return "2";
			}
		} else if(this.getWeaponType() == 'saberstaff') {
			if(this.bladeType == 'regular') {
				return "0";
			} else if(this.bladeType == 'short') {
				return "0";
			}
		} else if(this.getWeaponType() == 'single saber'){
			if(this.bladeType == 'long') {
				return "0";
			} else if(this.bladeType == 'regular') {
				return "0";
			} else if(this.bladeType == 'short') {
				return "1";
			} else if(this.bladeType == 'dagger') {
				return "3";
			}
		}
		return "ERROR";
	}
	this.getDodging = function() {
		if(this.handleType == 'regularHandle') {
			return "1";
		} else if(this.handleType == 'shortHandle') {
			return "0";
		} else if(this.handleType == 'longHandle') {
			return "2";
		} else if(this.handleType == 'curvedHandle') {
			return "0";
		} else if(this.handleType == 'crossguardHandle') {
			return "0";
		} else if(this.handleType == 'tonfaHandle') {
			return "0";
		} else if(this.handleType == 'forcePike') {
			return "3";
		}
	}
	this.getBlocking = function() {
		if(this.handleType == 'regularHandle') {
			return "2";
		} else if(this.handleType == 'shortHandle') {
			return "1";
		} else if(this.handleType == 'longHandle') {
			return "1";
		} else if(this.handleType == 'curvedHandle') {
			return "2";
		} else if(this.handleType == 'crossguardHandle') {
			return "0";
		} else if(this.handleType == 'tonfaHandle') {
			return "3";
		} else if(this.handleType == 'forcePike') {
			return "0";
		}
	}
	this.getDeflecting = function() {
		if(this.handleType == 'regularHandle') {
			return "0";
		} else if(this.handleType == 'shortHandle') {
			return "2";
		} else if(this.handleType == 'longHandle') {
			return "0";
		} else if(this.handleType == 'curvedHandle') {
			return "1";
		} else if(this.handleType == 'crossguardHandle') {
			return "3";
		} else if(this.handleType == 'tonfaHandle') {
			return "0";
		} else if(this.handleType == 'forcePike') {
			return "0";
		}
	}
	this.getUsage = function() {
		if(this.getWeaponType() == 'dual sabers') {
			return "dual wield";
		} else if(this.getWeaponType() == 'saberstaff') {
			return "saberstaff";
		} else if(this.handleType == 'forcePike') {
			return "force-pike"
		} else if( (this.handleType == 'shortHandle') || (this.handleType == 'curvedHandle') || (this.handleType == 'tonfaHandle') || (this.handleType == 'crossguardHandle') ) {
			return "one-handed";
		} else if(this.handleType == 'regularHandle') {
			if(this.bladeType == 'long') {
				return "two-handed";
			} else if(this.bladeType == 'short' || this.bladeType == 'dagger') {
				return "one-handed";
			} else {
				return "one-handed, two-handed";
			}
		} else if(this.handleType == 'longHandle') {
			return "two-handed";
		}
	}
	
	this.updateOverview = function() {
		// Slashing
		var html = '';
		for(var i = 0; i < 10; i++) {
			if(i%5 == 0) { html += ' '; }
			html += (i < this.getSlashing() ? '●' : '○');
		}
		$('#SlashingOverview').html(html);
		// Cutting
		html = '';
		for(var i = 0; i < 10; i++) {
			if(i%5 == 0) { html += ' '; }
			html += (i < this.getCutting() ? '●' : '○');
		}
		$('#CuttingOverview').html(html);
		// Piercing
		html = '';
		for(var i = 0; i < 10; i++) {
			if(i%5 == 0) { html += ' '; }
			html += (i < this.getPiercing() ? '●' : '○');
		}
		$('#PiercingOverview').html(html);

		// Dodging
		html = '';
		for(var i = 0; i < 10; i++) {
			if(i%5 == 0) { html += ' '; }
			html += (i < this.getDodging() ? '●' : '○');
		}
		$('#DodgingOverview').html(html);
		// Blocking
		html = '';
		for(var i = 0; i < 10; i++) {
			if(i%5 == 0) { html += ' '; }
			html += (i < this.getBlocking() ? '●' : '○');
		}
		$('#BlockingOverview').html(html);
		// Deflecting
		html = '';
		for(var i = 0; i < 10; i++) {
			if(i%5 == 0) { html += ' '; }
			html += (i < this.getDeflecting() ? '●' : '○');
		}
		$('#DeflectingOverview').html(html);
		
	}

}
