var since;

var usersLastTime = [];
var roomsLastTime;


function escapeHtml(string) {
	return String(string).replace(/[&<>"'\/]/g, function (s) {
		return entityMap[s];
	});
}

// Temporary start up function to select system
$(function() {
	refreshChatScreen();

	$("#chatscreen").scrollTop($("#chatscreen").height());
	$('#setunsetaliaspopup').draggable();
	$('#createnewroompopup').draggable();

	$('#textinput').focus();


	$('#textinput').keypress(function(e) {
		// enter key pressed
		if (e.which == 13) {
			// test if control or shift was also pressed
			if(e.ctrlKey) {
				// if so, go to next line
				$('#textinput').val($('#textinput').val() + "\n");
			} else if(e.shiftKey) {
				// do absolutely nothing - apparently text area's already cover this
			} else {
				// if not, submit
				submit();
			}
		}
	});


	setInterval( "refreshChatScreen();", 2000 );


})

// Replace all function doesn't exist in javascript String prototype o_O
function replaceAll(source,stringToFind,stringToReplace){
	var temp = source;
	var index = temp.indexOf(stringToFind);
	while(index != -1){
		temp = temp.replace(stringToFind,stringToReplace);
		index = temp.indexOf(stringToFind);
	}
	return temp;
}

function loadRoomList() {
	$('#roomlist').removeClass("hidden");
	$('#roomsbutton').addClass("activetab");
	$('#userlist').addClass("hidden");
	$('#usersbutton').removeClass("activetab");
	
	$('#createNewRoomButton').removeClass("hidden");
	$('#setunsetAliasButton').addClass("hidden");
}

function toggleIconsMenu() {
	$('#iconsmenu').toggleClass("hidden");
	if($('#iconsmenu').hasClass("hidden")) {
		$('#iconsbutton').html("Insert Icons &#9658");
		$('#roomusers').css("bottom", "0px");
		$('#topline').css("right", "250px");
	} else {
		$('#iconsbutton').html("Insert Icons &#9668");
		$('#roomusers').css("bottom", "100px");
		$('#topline').css("right", "0px");
	}
}

function loadUserList() {
	$('#userlist').removeClass("hidden");
	$('#usersbutton').addClass("activetab");
	$('#roomlist').addClass("hidden");
	$('#roomsbutton').removeClass("activetab");
	
	$('#createNewRoomButton').addClass("hidden");
	$('#setunsetAliasButton').removeClass("hidden");
}

function openCreateRoomPopup() {
	$('#createnewroompopup').show();
}

function closeCreateRoomPopup() {
	$('#createnewroompopup').hide();
	$('#createnewroompopup').css("left", "50%");
	$('#createnewroompopup').css("top", "50%");
	$('#createnewroompopup').css("margin-top", "-135px");
	$('#createnewroompopup').css("margin-left", "-200px");
}

function openAliasPopup() {
	$('#setunsetaliaspopup').show();
}

function closeAliasPopup() {
	$('#setunsetaliaspopup').hide();
	$('#setunsetaliaspopup').css("left", "50%");
	$('#setunsetaliaspopup').css("top", "50%");
	$('#setunsetaliaspopup').css("margin-top", "-75px");
	$('#setunsetaliaspopup').css("margin-left", "-150px");
}

function selectme(e) {
	$(".roomiconselect").removeClass("selected");
	$(e).addClass("selected");
}

function makeDate(unix_timestamp) {
	var date = new Date(unix_timestamp * 1000);

	var dateString = "";

	dateString += date.getFullYear();

	var month = "" + date.getMonth();
	while(month.length <= 1) {
		month = "0" + month;
	}
	dateString += "-" + month;

	var day = "" + date.getDay();
	while(day.length <= 1) {
		day = "0" + day;
	}
	dateString += "-" + day;

	return dateString;
}

function makeTime(unix_timestamp) {
	var date = new Date(unix_timestamp * 1000);

	var timeString = "";

	var hour = "" + date.getHours();
	while(hour.length <= 1) {
		hour = "0" + hour;
	}
	timeString += hour;

	var minutes = "" + date.getMinutes();
	while(minutes.length <= 1) {
		minutes = "0" + minutes;
	}
	timeString += ":" + minutes;

	var seconds = "" + date.getSeconds();
	while(seconds.length <= 1) {
		seconds = "0" + seconds;
	}
	timeString += ":" + seconds;


	return timeString;
}

var entityMap = {
    "&": "&amp;",
    "<": "&lt;",
    ">": "&gt;",
    '"': '&quot;',
    "'": '&#39;',
    "/": '&#x2F;'
};

function getAliasString() {
	var aliasName = $('#aliasName').val().replace(" ", "_");
	var aliasImage = $('#aliasImage').val().replace(" ", "_");

	if(aliasName.length > 0 && aliasImage.length > 0) {
		return "[mask][name]" + aliasName + "[avatar]" + aliasImage + "[/mask]";
	} else {
		return "";
	}
}

function bbCode(open, close) {
	var text = $('#textinput').val();
	var start = $('#textinput')[0].selectionStart;
	var end = $('#textinput')[0].selectionEnd;
	var sel = text.substring(start, end);
	$('#textinput').val(text.substring(0, start) + open + sel + close + text.substr(end));
	$('#textinput').focus();
}

function insert_text(icontext) {
	var text = $('#textinput').val();
	var index = $('#textinput')[0].selectionStart;
	$('#textinput').val(text.substring(0, index) + " " + icontext + " " + text.substr(index));
	$('#textinput').focus();
}

function refreshChatScreen() {
	$.getJSON('chatIO.php?topic=' + chatroom + '&since=' + since, function(mainDataArray) {

		if(mainDataArray['dataForRoom'] != chatroom) {
			// drop data
			return;
		}
		var didPost = false;
		var currentRoomName = mainDataArray['currentRoomName'];
		// set breadcrumb
		var breadcrumbname = currentRoomName.replace(/[&<>"'\/]/g, function (s) {
			return entityMap[s];
		});
		$('#roomnameforbreadcrumb').html(breadcrumbname);
		$('#icoocroombreadcrumb').html(mainDataArray['currentRoomType']);

		since = mainDataArray['since'];

		var data = mainDataArray['posts'];

		for(var i=0; i<data.length; i++) {
			var line = data[i];

			// ignore any messages we already have
			if($('#p'+line.id).length != 0) continue;

			var lineHTML = parseLine(line);
			$( "#chatscreen" ).append(lineHTML);
			didPost = true;
			$( '#chatscreen' ).scrollTop( $( '#chatscreen' ).prop( "scrollHeight") );
		}
		// limit number of messages in history
		var i = 0;		

		$($( "#chatscreen" ).children('div').get().reverse()).each(function() {
			i++;
			if(i > 25) {
				$(this).remove();
			}
		})

		var userlist = mainDataArray['users'];

		userlist.sort(userSorter);


		triggerUserEntryAndLeaveMessages(userlist, usersLastTime, currentRoomName);

		if(JSON.stringify(userlist) != JSON.stringify(usersLastTime)) {
			$( "#userlist_here" ).html('<div class="listheader">In this room</div>');
			$( "#userlist_elsewhere" ).html('<div class="listheader">In other rooms</div>');

			for(var i=0; i<userlist.length; i++) {
				var user = userlist[i];
				if($.inArray(currentRoomName, user['rooms']) >= 0) {
					$( "#userlist_here" ).append(parseuser(user));
				} else {
					$( "#userlist_elsewhere" ).append(parseuser(user));
				}
			}
		}

		usersLastTime = [];

		usersLastTime = userlist;

		var roomlist = mainDataArray['rooms'];


		roomlist.sort(roomSorter);




		if(JSON.stringify(roomlist) != roomsLastTime) {
			if(roomlist.length > 0) {
				$( "#roomlist" ).html('<div class="listheader">Rooms</div>');
			}
			for(var i=0; i<roomlist.length; i++) {
				var room = roomlist[i];
				$( "#roomlist" ).append(parseroom(room));

				if(room['id'] == chatroom) {
					$('#roomTitle').html("Users in " + room['name'] + ":");
				}
			}
			roomsLastTime = JSON.stringify(roomlist);
		}
		
		if(didPost) {
			document.getElementById("ploink").play();
		}


	});
}

function parseLine(line) {
	var html = "<div class='chatmessage' id='";
	html += 'p'+escapeHtml(line.id);
	html += "'><img class='chaticon' src='";
	html += escapeHtml(line.avatar);
	html += "' />";
	
	html += "<div class='chatcontent'>";
	html += "<span class='chatusername username'>";
	html += escapeHtml(line.alias);
	if(line.alias != line.poster) {
		html += "</b> (mask of <b>";
		html += escapeHtml(line.poster);
		html += "</b>)";
	} else {
		html += "</b>";
	}
	html += "</span>";
	html += "<span class='chattimestamp'><a title='";
	html += makeDate(line.timestamp);
	html += "'>";
	html += makeTime(line.timestamp);
	html += "</a></span><br/>";

	html += "<span class='chattext'>";
	html += line.text;
	html += "</span></div></div>";

	return html;
}

//This will sort your array
function userSorter(a, b){
	var aType = a['name'];
	var bType = b['name'];

	return ((aType < bType) ? -1 : ((aType > bType) ? 1 : 0));
}

function parseuser(user) {
	var userName = user['name'];
	var userAvatar = user['avatar'];
	var userURL = user['url'];

	var rooms = "";
	for($room in user['rooms']) {
		rooms += "&bull; " + escapeHtml(user['rooms'][$room]) + "\n";
	}

	if(!userURL || userURL.length == 0) {
		userURL = "/dokuwiki/ic:" + userName;
	}

	html = '<div onclick="toggleOpenable(this)" title="';
	html += escapeHtml(userName);
	html += '" class="listentry">';
		html += '<img class="chaticon" src="';
		html += escapeHtml(userAvatar);
		html += '" />';
		html += '<span class="namespan">';
			html += '<span class="username">';
			html += escapeHtml(userName);
		html += '</span>'
		html += '</span>';
		html += '<div class="userbuttons">';
			html += '<a target="_blank" title="Open a PM to the user in a separate window." href="/tools/chattest/pm.php?partner=';
			html += escapeHtml(user['id']);
		html += '"><div class="pm"></div></a>';
			html += '<a href="';
			html += escapeHtml(userURL);
			html += '" target="_blank" title="View this users profile in a separate window."><div class="chatprofilelink"></div></a>';
		html += '</div>';
		html += '<div class="openable hidden">In rooms: <br/>';
			html += replaceAll(rooms, "\n", "<br/>");
		html += '</div>';
	html += '</div>';

	return html;
}

//This will sort your array
function roomSorter(a, b){
	var aType = a['roomtype'];
	var bType = b['roomtype'];

	if(aType < bType) {
		return -1;
	} else if (aType > bType) {
		return 1;
	} else {
		var aName = a['name'].toLowerCase();
		var bName = b['name'].toLowerCase(); 
		return ((aName < bName) ? -1 : ((aName > bName) ? 1 : 0));
	}
}

function parseroom(room) {

	var roomname = room['name'];
	var shortenedRoomName;
	if(roomname.length > 50) {
		shortenedRoomName = escapeHtml(roomname.substr(0,50)) + "&hellip;";
	} else {
		shortenedRoomName = escapeHtml(roomname);
	}

	var usersInRoom = "";
	for($user in room['currentUsers']) {
		usersInRoom += "&bull; " + escapeHtml(room['currentUsers'][$user]) + "\n";
	}


	var html = '<div onclick="toggleOpenable(this)" title="';
	html += escapeHtml(room['name']);
	html += '" class="listentry">' ;
	html += '<img class="chaticon" src="/phpbb/styles/prosilver/imageset/sticky.png" />';
	html += '<span class="roomnamespan"><span style="font-weight:bold">';
	html += shortenedRoomName;
	html += '</span>';
	
	html += '</span>';
	html += '<a title="Join this room" href=".?topic='
	html += room['id'];
	html += '"><div class="joinroomicon"></div></a>';
	html += '<div class="openable hidden">Users: <br/>';
	html += replaceAll(usersInRoom, "\n", "<br/>");
	html += '</div>';
		// room['roomtype']
	return html;
}

function toggleOpenable(e) {
	$(e).find(".openable").toggleClass("hidden");
}

function submit() {

	// no text, erase and dont post
	if($('#textinput').val().trim() == "") {
		$('#textinput').val('');
		return;
	}
	// ext, post
	$.post("chatIO.php?topic=" + chatroom, { "message" : getAliasString() + $('#textinput').val() }, 
		function(data) { 
			$('#textinput').val(''); 
		}
	);

}

function triggerUserEntryAndLeaveMessages(userList, usersLastTime, currentChatRoom) {

	if(usersLastTime.length == 0) {
		return;
	}

	// usernames of those currently in the chat
	var currUsers = [];

	var nl = [];
	var ol = [];

	for(var user in userList) {
		var name = userList[user]['name'];
		if($.inArray(currentChatRoom, userList[user]['rooms']) >= 0) {
			nl.push(name);
		}
	}


	var oldUsers = [];
	for(var user in usersLastTime) {
		var name = usersLastTime[user]['name'];
		if($.inArray(currentChatRoom, usersLastTime[user]['rooms']) >= 0) {
			ol.push(name);
		}
	}

	for(var wasHere in ol) {
		if($.inArray(ol[wasHere], nl) < 0) {
			// user left
			addClientMessage(ol[wasHere] + " has left the room.");	
		}
	}

	for(var isHere in nl) {
		if($.inArray(nl[isHere], ol) < 0) {
			// user arrived
			addClientMessage(nl[isHere] + " has entered the room.");	
		}
	}
	
}

function addClientMessage(message) {
	var html = "<div class='chatmessage'><img class='chaticon' src='ServerMessage.png' />";
	
	html += "<div class='chatcontent'>";
	html += "<span class='chatusername username'>";
	html += message;
	html += "</span>";
	html += "<span class='chattimestamp'><a title='";
	html += makeDate(Math.round((new Date()).getTime() / 1000));
	html += "'>";
	html += makeTime(Math.round((new Date()).getTime() / 1000));
	html += "</a></span><br/>";

	html += "<span class='chattext'>";
	html += "</span></div></div>";

	$( "#chatscreen" ).append(html);
	$( '#chatscreen' ).scrollTop( $( '#chatscreen' ).prop( "scrollHeight") );

}

function createRoom() {
	var roomName = $("#newroomname").val();
	var roomType = $('input[name=icoocroom]:checked').val();
	var privateOrNot = $("#privateroom").is(":checked");
	var icon = "None";
	var description = $("#roomdescription").val();

$.post("createRoom.php", 
	{ 
		"roomname" : roomName,
		"roomtype" : roomType,
		"private" : privateOrNot,
		"locationicon" : icon,
		"description" : description,
	}, 
		function(data) { 
			window.location.href = "/tools/chattest/?topic=" + data['topicid'];
		}
	);


}
