// This file contains the Character details

// Create a new character
var faction = new Faction();

/**
 * Load the Faction Image when an entry is typed so you can see immidiately if you typed correctly. This method is called onChange of the image field.
 * 
 * @param image the image to load (as entered into the wiki
 */
function loadFactionImage(image) {
	$('#factionImage').attr("src", "/dokuwiki/_media/" + image);
}

/**
 * This function handles the insertion of the image after being selected in the wiki tab - it cleans up the selected name to be in the proper format, sets the value for the data model of this builder and updates the image.
 * 
 * @param varA is always "wiki__text"
 * @param varB is the start of the image tag (including {{: as a start and | as an end
 * @param varC is }}
 * @param varD is an empty string
 */
var insertTags = function(varA, varB, varC, varD) {
	$('#imageFieldEntry').val(varB.substring(3,varB.indexOf("?")));
	faction.setImage($('#imageFieldEntry').val());
	loadFactionImage($('#imageFieldEntry').val());
}

function Faction() {

	this.name;
	this.getName = function() {
		return this.name;
	}
	this.setName = function(newName) {
		this.name = newName.replace(/^\s\s*/, '').replace(/\s\s*$/, '');
	}

	this.getRole = function() {
		return "Union member";
	}
	
	this.image = "ic:default-faction.png";
	this.getImage = function() {
		return this.image;
	}
	this.setImage = function(newImage) {
		this.image = newImage.replace(/^\s\s*/, '').replace(/\s\s*$/, '');
	}
	
	this.getAllegiance = function() {
		return "Union";
	}
	
	this.status;
	this.getStatus = function() {
		return this.status;
	}
	this.setStatus = function(newStatus) {
		this.status = newStatus.replace(/^\s\s*/, '').replace(/\s\s*$/, '');
	}
	
	this.getDesciption = function() {
		return this.getName() + " is a " + this.getStatus() + " of the [[" + this.getAllegiance() + "]]";
	}
	
	this.logo;
	this.getLogo = function() {
		return this.logo;
	}
	this.setLogo = function(newLogo) {
		this.logo = newLogo.replace(/^\s\s*/, '').replace(/\s\s*$/, '');
	}
	
	this.getType = function() {
		return "PC";
	}
	
	this.user;
	this.getUser = function() {
		return this.user;
	}
	this.setUser = function(newUser) {
		this.user = newUser.replace(/^\s\s*/, '').replace(/\s\s*$/, '');
	}
	
	this.baseSystem;
	this.getBaseSystem = function() {
		return this.baseSystem;
	}
	this.setBaseSystem = function(newBaseSystem) {
		this.baseSystem = newBaseSystem.replace(/^\s\s*/, '').replace(/\s\s*$/, '');
	}
	
	this.toWikiString = function() {
		var text = "====== " + this.getName() + " ======\n\n"

		text += "<data !wip #wip>\n";
		text += "User [ref::user]  : " + this.getUser() + "\n";
		text += "Description[wiki] : Page generated using the [[https://www.fwurg.net/tools/faction-builder/faction.php|Faction Builder]]\n";
		text += "Page [ref]        : [[]]\n";
		text += "</data>\n\n";

		text += "<data !unvalidated #unvalidated>\n";
		text += "User [ref::user]   : " + this.getUser() + "\n";
		text += "Description [wiki] : New Factions require approval from a [[rules:storyteller]]. You can ask them for approval on the [[https://www.fwurg.net/phpbb/viewforum.php?f=9|forum]]\n";
		text += "Page [ref]         : [[]]\n";
		text += "</data>\n\n";

		text += "<data faction !union_member>\n"
		text += "Description [wiki] : " + this.getDesciption() + "\n";
		text += "Roles*             : " + this.getRole() + "\n";
		text += "Status [rule]      : Candidate World\n";
		text += "Image [image::300] : " + this.getImage() + "\n";
		text += "Allegiance [ref]*  : " + this.getAllegiance() + "\n";
		text += "Base System [ref]  : " + (this.getBaseSystem() ? this.getBaseSystem() : "") + "\n";
		text += "Type [rule]        : " + this.getType() + "\n";
		text += "User [ref::user]   : " + this.getUser() + "\n";
		text += "</data>\n\n";
		text += "YOUR DESCRIPTION HERE!\n";

		return text;
	}
	
}

$(function() {
	$('#statusSelect .select').click(function() {
		$(this).addClass("selected").siblings().removeClass("selected");
		faction.setStatus($(this).data("status"));
	}).filter(':first').click();

})

function replaceAll(Source,stringToFind,stringToReplace){
	var temp = Source;
	var index = temp.indexOf(stringToFind);
	while(index != -1){
		temp = temp.replace(stringToFind,stringToReplace);
		index = temp.indexOf(stringToFind);
	}
	return temp;
}

function createFactionAccount() {
	// sanity check
	if(!faction.getName() || faction.getName().length <= 0) {
		alert("You have not yet chosen a faction name.");
		return;
	}
	if(!faction.getImage() || faction.getImage().length <= 0) {
		alert("No faction image has been selected.");
		return;
	}
	

    var form = document.createElement("form");
    form.setAttribute("method", "post");
    form.setAttribute("action", "/tools/faction-builder/create.php");

// masterAccount from userEntry field
    var masterAccount = document.createElement("input");
    masterAccount.setAttribute("type", "hidden");
    masterAccount.setAttribute("name", "masterAccount");
    masterAccount.setAttribute("value", faction.getUser());
    form.appendChild(masterAccount);

// factionname from faction.getName()

    var factionname = document.createElement("input");
    factionname.setAttribute("type", "hidden");
    factionname.setAttribute("name", "factionname");
    factionname.setAttribute("value", faction.getName());
    form.appendChild(factionname);

// image from faction.getImage()
    var image = document.createElement("input");
    image.setAttribute("type", "hidden");
    image.setAttribute("name", "image");
    image.setAttribute("value", "/dokuwiki/_media/" + faction.getImage());
    form.appendChild(image);

// wikiurl from faction.getName()
// link to the wiki page url (based on faction name)
    var wikiurl = document.createElement("input");
    wikiurl.setAttribute("type", "hidden");
    wikiurl.setAttribute("name", "wikiurl");
    wikiurl.setAttribute("value", "/dokuwiki/ic:" + faction.getName().replace(":", "_").replace(";", "_"));
    form.appendChild(wikiurl);

    var wikitext = document.createElement("textarea");
    wikitext.setAttribute("name", "wikitext");
    wikitext.setAttribute("style", "display:none;");
    $(wikitext).text(faction.toWikiString());
    form.appendChild(wikitext);

    document.body.appendChild(form);
    form.submit();
}

