(function($) {

var orderer = function(comparator) {
	return function() {
		$(this).closest('.ordering').find('.insetbutton').removeClass('active');
		$(this).addClass('active');

		var $list = $(this).closest('.forumbg');
		$list.find('.row').sortElements(comparator);
	};
}

$(document).ready(function() {
	$('.ordering').append("<a class='insetbutton order-last-post active'>Latest post</a>");

	var lastPostFirst = function(a, b) {
		return $(a).attr('data-lastpost') < $(b).attr('data-lastpost') ? 1 : -1;
	}

	$('.order-last-post').click(orderer(lastPostFirst));

	$('.ordering').append("<a class='insetbutton order-forum'>Forum</a>");

	$('.order-forum').click(orderer(function(a,b) {
		var af = $(a).find('.field_forum').text();
		var bf = $(b).find('.field_forum').text();

		if(af < bf) {
			return -1;
		} else if(bf < af) {
			return 1;
		} else {
			return lastPostFirst(a, b);
		}
	}));

	$('.ordering').append("<a class='insetbutton order-follow-colour'>Followed colour</a>");

	var score = function(x) {
		var $x = $(x).find('.followWidget');
		if($x.hasClass('followed-red')) return 0;
		if($x.hasClass('followed-yellow')) return 1;
		if($x.hasClass('followed-green')) return 2;
		if($x.hasClass('followed-blue')) return 3;
		if($x.hasClass('unfollowed')) return 10;
		return 100;
	};

	$('.order-follow-colour').click(orderer(function(a,b) {
		var ac = score(a);
		var bc = score(b);
		if(ac < bc ) {
			return -1;
		} else if(bc < ac) {
			return 1;
		} else {
			return lastPostFirst(a,b);
		}
	}));


});

})(jQuery);
