/**
Idea:

Step 1: Select Faction
Step 2: Provide next turns population growth as turn report text



Later:

- Adjust wiki button to grow the population
- Projected Growth in future turns
- As a graph

*/

var pgc_groups = new Array();

$(function() {

	// initialize new wiki object
	var wiki = new fwurg.Wiki();
	var qb = wiki.qb();

	// query all races
	wiki.queryResources(qb.query(
		qb.fields('?race'),
		qb.where(
			'?race entry title: ?title',
			'?race is a: race\n'
		),
		qb.sort('?title')
	)).then(function(data) {
	
		var pgc_races = false;
		var pgc_worlds = false;

	
		var temp = data.body;
		var arr = new Object();
		for(var k in temp) {
		
			var highFec = $.inArray("rules:high_fecundity", temp[k]['Racial Characteristics']) >= 0;
			var highFer = $.inArray("rules:high_fertility", temp[k]['Racial Characteristics']) >= 0;
			var aquatic = $.inArray("rules:aquatic", temp[k]['Racial Characteristics']) >= 0;
			var cyborgs = $.inArray("rules:cyborg", temp[k]['Racial Characteristics']) >= 0;
		
			var race = new Race(k, temp[k]['Plural'], highFec, highFer, aquatic, cyborgs, temp[k]['Image']);
			arr[k] = race;
		}
		pgc_races = arr;
		
		// query all worlds
		wiki.queryResources(qb.query(
			qb.fields('?world'),
			qb.where(
				'?world entry title: ?title',
				'union {',
					'{\n?world is a: Planet\n}',
					'{\n?world is a: Moon\n}',
				'}'
			),
			qb.sort('?title')
		)).then(function(data) {
			var temp = data.body;
			var arr = new Object();
			for(var k in temp) {
                console.log(k,': ',temp[k]);
			
				var ocean = temp[k]['Ocean'] == "rules:water_ocean";
				var natLife = temp[k]['Ecosystem'] == "rules:natural_life";
				var atmos;
				if( temp[k]['Atmosphere'] == "rules:type_i_atmosphere") {
					atmos = 1;
				} else if (temp[k]['Atmosphere'] == "rules:type_ii_atmosphere") {
					atmos = 2;
				} else if (temp[k]['Atmosphere'] == "rules:type_iii_atmosphere") {
					atmos = 3;
				} else if (temp[k]['Atmosphere'] == "rules:type_iv_atmosphere") {
					atmos = 4;
				} else {
					atmos = 0;
				}
				
				var world = new World(k, temp[k]['entry title'], atmos, ocean, natLife, temp[k]['Zones'], temp[k]['Image']);
				arr[k] = world;
			}
			pgc_worlds = arr;
			
			// query all factions for their proper names
			wiki.queryResources(qb.query(
				qb.fields('?fac'),
				qb.where(
					'?fac is a: Faction', 
					'?fac Type[rule]: PC',
					'?fac entry title: ?title',
					'union {',
						'{\n?fac Status[rule]: Inner World\n}',
						'{\n?fac Status[rule]: Core World\n}',
					'}'
				),
				qb.sort('?title')
			)).then(function(data) {
				var temp = data.body;
				var arr = new Object();
				for(var k in temp) {
					arr[k] = temp[k]['entry title'];
				}

				// query active population groups
				wiki.queryResources(qb.query(
					qb.fields('?pop'),
					qb.where(
						'?pop is a: population', 
						'?pop Faction[ref]: ?fac',
						'?pop On[ref]: ?loc',
						'?fac Type[rule]: PC',
						'union {',
							'{\n?fac Status[rule]: Inner World\n}',
							'{\n?fac Status[rule]: Core World\n}',
						'}'
					)
				)).then(function(data) {
					var temp2 = data.body;
					for(var k in temp2) {
						var group = new Group(pgc_races[temp2[k]['Race']], pgc_worlds[temp2[k]['On']], temp2[k]['Number'], arr[temp2[k]['Faction']]);
						pgc_groups.push(group);
					}
					$('#mainbodypod').removeClass("loading");
					$('#mainbodypod').html('<table id="selectFactionTable"><tr><td style="width:148px;">Select Faction</td><td><div id="selectFaction"></div></td></tr></table><table id="popGroups" class="zebra"></table>');
					$("#popGroups").html(getGrowthHeader());

					for(var k in temp) {
						$('#selectFaction').append("<div id='pgc_" + k.substr(3) + "' class='select' onclick='factionSelect(\"pgc_" + k.substr(3) + "\", \"" + temp[k]['entry title'] + "\");'><img class='selectimage' src='/dokuwiki/_media/" + temp[k]['Image'] + "?w=64'><div style='padding-left:68px;padding-top:2px;'><a target='_blank' href='/dokuwiki/" + k + "'>" + temp[k]['entry title'] + "</a></div></div>");
					}
				
				});
			});			
		});		
	});
	



});

/**
 * Handles the selection of a faction in the menu.
 *
 * @param id the id of the div of the faction (used to set selection)
 * @param selectedFaction the human readible name of the faction that was selected
 */
function factionSelect(id, selectedFaction) {
	//alert(id + "\n" + selectedFaction);
	$("#" + id).addClass("selected").siblings().removeClass("selected");
	
	var v = "";
	
	var popGrowthText = "[b]Population Growth[/b]\r\n\r\n";

	var popGrowCost = "";
	var costTotal = 0;
	
	for(var index in pgc_groups) {
		var group = pgc_groups[index];
		if(group.getFaction() == selectedFaction) {
		
		var uniqueID = group.getRaceObject().getWikiName().substr(3) + "__" + group.getWorldObject().getWikiName().substr(3);

		var html = "<tr>";
		   html += "<td><img style='margin-top:1px;margin-bottom:1px;border-width:1px;border-style:solid;border-color:gray;width:64px;height:64px;' src='/dokuwiki/_media/" + group.getRaceObject().getImage() + "?w=64'></td><td><a target='_blank' href='/dokuwiki/" + group.getRaceObject().getWikiName() + "'>" + group.getRaceObject().getPlural() + "</td>";
		   html += "<td><img style='margin-top:1px;margin-bottom:1px;border-width:1px;border-style:solid;border-color:gray;width:64px;height:64px;' src='/dokuwiki/_media/" + group.getWorldObject().getImage() + "?w=64'></td><td><a target='_blank' href='/dokuwiki/" + group.getWorldObject().getWikiName() + "'>" + group.getWorldObject().getWorldName() + "</td>";
		   html += "<td>" + (group.getPopulationTotal() >= 10 ? "" : "&nbsp;") + group.getPopulationTotal().toFixed(2) + "<a target='_blank' href='/dokuwiki/rules:population' title='Population'><img style='margin-left:5px;margin-right:5px;' class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/population.png' /></a></td>";
		   html += "<td id='" + uniqueID + "_growth' class='normalLinkCss'>" + (group.getGrowthPercentage() * 100) + "&nbsp;%</td>";
		   html += "<td><span id='" + uniqueID + "_newpopa'>" + (group.getNewPopulation() >= 10 ? "" : "&nbsp;") + group.getNewPopulation().toFixed(2) + "<a target='_blank' href='/dokuwiki/rules:population' title='Population'><img style='margin-left:5px;margin-right:5px;' class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/population.png' /></a></span> <span id='" + uniqueID + "_newpopb'>(+ " + group.getPopulationGrowth().toFixed(2) + ")</span></td>";
		   if(Math.floor(group.getPopulationTotal()) == Math.floor(group.getNewPopulation())) {
				html += "<td id='" + uniqueID + "_pgc' >N / A</td>";
		   } else {
				html += "<td id='" + uniqueID + "_pgc'>" + ((parseInt(group.getWorldObject().getNumberOfZones()) * 100) * group.getPGCreduction()) + "<a target='_blank' href='/dokuwiki/rules:taxes' title='Taxes'><img style='margin-left:5px;margin-right:5px;'class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/tax.png' /></a></td>";
		   }
		   html += "</tr>";
		
			v += html;
			popGrowthText += group.getRace() + " on " + group.getWorld() + " grow from " + group.getPopulationTotal().toFixed(2) + " (:pop) by " + (group.getGrowthPercentage() * 100) + "% ( " + group.getPopulationGrowth().toFixed(2) + " (:pop)) to " + group.getNewPopulation().toFixed(2) + " (:pop)\n";
			if(Math.floor(group.getPopulationTotal()) != Math.floor(group.getNewPopulation())) {
				popGrowCost += group.getRace() + " on " + group.getWorld() + " population growth cost: + __ (:tax) -> [_IN_]COMPLETE ( __ / " + ((parseInt(group.getWorldObject().getNumberOfZones()) * 100) * group.getPGCreduction()) + " (:tax)) # Please fill in the 3 missing values\n"
				costTotal += ((parseInt(group.getWorldObject().getNumberOfZones()) * 100) * group.getPGCreduction());
			}
		}
	}
	$("#popGroups").html(getGrowthHeader() + v);
	
	if(costTotal > 0) {
		popGrowthText += "\n[b]Population Growth Cost[/b]\n\n" + popGrowCost + "\nTotal cost: " + costTotal + " (:tax)\n";	
	}
	
	$("#turnReportText").val(popGrowthText);
	
	// set mouseovers
	
	for(var index in pgc_groups) {
		var group = pgc_groups[index];
		if(group.getFaction() == selectedFaction) {
			var uniqueID = group.getRaceObject().getWikiName().substr(3) + "__" + group.getWorldObject().getWikiName().substr(3);
			$('#' + uniqueID + '_growth').poshytip({
				className: 'tip-darkgray',
				bgImageFrameSize: 11,
				offsetX: -25,
				content: "<div class='pgc_mouseover'>" + group.getGrowthPercentageExplanation() + "</div>"
			});		

			$('#' + uniqueID + '_newpopa').poshytip({
				className: 'tip-darkgray',
				bgImageFrameSize: 11,
				offsetX: -25,
				content: "<div class='pgc_mouseover'>" + group.getPopulationGrowthExplanationA() + "</div>"
			});		

			$('#' + uniqueID + '_newpopb').poshytip({
				className: 'tip-darkgray',
				bgImageFrameSize: 11,
				offsetX: -25,
				content: "<div class='pgc_mouseover'>" + group.getPopulationGrowthExplanationB() + "</div>"
			});		

			$('#' + uniqueID + '_pgc').poshytip({
				className: 'tip-darkgray',
				bgImageFrameSize: 11,
				offsetX: -25,
				content: "<div class='pgc_mouseover'>" + group.getPGCExplanation() + "</div>"
			});		
		}
	}
	
	
}

function getGrowthHeader() {
	return "<tr><th style='width:66px'>&nbsp;</th><th style='width:313px'>Race</th><th style='width:66px'>&nbsp;</th><th style='width:213px'>World</th><th style='width:100px'>Current</th><th style='width:100px'>% Growth</th><th style='width:200px'>Turn " + $('#hiddenTurnNumber').html() + "</th><th style='width:100px'>PGC</th></tr>";
}

/**
 * Calculates the percentages of the number based on the race growth rounding rules
 *
 * @param number the number to get the percentage of (ex. 1.92)
 * @param percentage the percentage to get (ex. 0.02)
 * @return the percentage of the number (ex. 0.03)
 */
function getRoundedPercentage(number, percentage) {
	return Math.floor((number * percentage) * 100) / 100;
}

/**
 * Actual population group
 *
 * @param race the race of the group
 * @param planet the planet of the group
 * @param num the total amount of population
 * @param faction the human readable name of the faction
 */
function Group(race, world, num, faction) {

	/**
	 * Get the population after growth including the newly generated populations
	 */
	this.getNewPopulation = function() {
		return this.getPopulationGrowth() + this.getPopulationTotal();
	}

	this.getPopulationGrowth = function() {
		return getRoundedPercentage(this.getPopulationTotal(), this.getGrowthPercentage());
	}

	this.factionName = faction;
	this.getFaction = function() {
		return this.factionName;
	}

	this.raceObject = race;
	this.getRace = function() {
		return this.raceObject.getPlural();
	}
	this.getRaceObject = function() {
		return this.raceObject;
	}
	
	this.worldObject = world;
	this.getWorld = function() {
		return this.worldObject.getWorldName();
	}
	this.getWorldObject = function() {
		return this.worldObject;
	}

	this.number = parseFloat(num);
	this.getPopulationTotal = function() {
		return this.number;
	}	

	this.getPGCreduction = function() {
		reductionFactor = 1;
		if(this.worldObject.getAtmosphere() == 1 && this.worldObject.getOcean() && (this.raceObject.getFecundity() || this.raceObject.getFertility())) {
			reductionFactor -= 0.5;
		}
		if(this.worldObject.getNaturalLife() && this.worldObject.getOcean() && this.raceObject.getAquatic()) {
			reductionFactor -= 0.25;
		}		
		return reductionFactor;
	}
	
	this.getPGCExplanation = function() {
		var str = "";
		if(Math.floor(this.getPopulationTotal()) == Math.floor(this.getNewPopulation())) {
			str += "No <a target='_blank' href='/dokuwiki/rules:population' title='Population'><img style='margin-left:5px;margin-right:5px;' class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/population.png' /></a> barrier crossed.";
		} else {
			str += ((parseInt(this.getWorldObject().getNumberOfZones()) * 100) * this.getPGCreduction()) + " <a target='_blank' href='/dokuwiki/rules:taxes' title='Taxes'><img style='margin-left:5px;margin-right:5px;'class='icon' src='/dokuwiki/lib/plugins/fwurgicons/images/tax.png' /></a> = ";
			str += "(" + (parseInt(this.getWorldObject().getNumberOfZones())) + " Zones * 100)<sub>Base</sub>";
			if(this.worldObject.getAtmosphere() == 1 && this.worldObject.getOcean() && (this.raceObject.getFecundity() || this.raceObject.getFertility())) {
				if(this.raceObject.getFecundity()) {
					str += " -50%<sub>High Fecundity with Type I Atmosphere & Oceans</sub>";
				} else if (this.raceObject.getFertility()) {
					str += " -50%<sub>High Fertility with Type I Atmosphere & Oceans</sub>";
				}
			}
			if(this.worldObject.getNaturalLife() && this.worldObject.getOcean() && this.raceObject.getAquatic()) {
				str += " -25%<sub>Aquatic with Oceans and Natural Life</sub>";
			}		
			
		}
		return str;
	}
	
	this.getPopulationGrowthExplanationB = function() {
		var popnumStr = (this.getPopulationTotal() * (this.getGrowthPercentage())).toFixed(10);
		var rest = popnumStr.substr(popnumStr.indexOf(".") + 3).replace(/0*$/, '');
		
		var str = ""
		str += getRoundedPercentage(this.getPopulationTotal(), this.getGrowthPercentage()).toFixed(2);
		if(rest.length > 0) {
			str += "<span class='droppednumbers'>" + rest + "</span>";
		}
		str += " = " + this.getPopulationTotal() + " * " + (this.getGrowthPercentage() * 100) + "%";
		return str;
	}

	this.getPopulationGrowthExplanationA = function() {
		var str = "";
		str += this.getNewPopulation().toFixed(2);
		str += " = " + this.getPopulationTotal() + " + " + getRoundedPercentage(this.getPopulationTotal(), this.getGrowthPercentage()).toFixed(2);;
		return str;
	}
	
	this.getGrowthPercentageExplanation = function() {
		var str = "";
		   str += (this.getGrowthPercentage() * 100) + "% = ";
		   str += (this.getBaseGrowthPercentage() * 100) + "%<sub>Base</sub>";
		if(this.raceObject.getCyborg() && this.worldObject.getAtmosphere() > 0) {
		   str += " +1%<sub>Cyborg and Atmosphere</sub>"
		} else if(this.raceObject.getAquatic() && this.worldObject.getOcean() && this.worldObject.getNaturalLife()) {
		   str += " +1%<sub>Aquatic, Ocean and Natural Life</sub>"
		} else if(this.worldObject.getAtmosphere() == 1 || this.worldObject.getAtmosphere() == 2) {
		   str += " +1%<sub>Type I or II Atmosphere</sub>"
		}
		if(this.raceObject.getFertility()) {
		   str += " +0.5%<sub>High Fertility</sub>"
		}
		if(this.raceObject.getFecundity()) {
		   str += " +0.5%<sub>High Fecundity</sub>"
		}
		return str;
	}
	
	// base growth percentage is 1%
	this.getBaseGrowthPercentage = function() {
		return 0.01;
	}
	
	this.getPlanetGrowthPercentage = function() {
		var percentage = 0;
		if(this.raceObject.getCyborg() && this.worldObject.getAtmosphere() > 0) {
			percentage = 0.01;
		} else if(this.raceObject.getAquatic() && this.worldObject.getOcean() && this.worldObject.getNaturalLife()) {
			percentage = 0.01;
		} else if(this.worldObject.getAtmosphere() == 1 || this.worldObject.getAtmosphere() == 2) {
			percentage = 0.01;
		}
		return percentage;
	}
	
	this.getRaceGrowthPercentage = function() {
		var percentage = 0;
		if(this.raceObject.getFertility()) {
			percentage += 0.005;
		}
		if(this.raceObject.getFecundity()) {
			percentage += 0.005;
		}
		return percentage;
	}
	
	this.getGrowthPercentage = function() {
		return this.getBaseGrowthPercentage() + this.getPlanetGrowthPercentage() + this.getRaceGrowthPercentage();
	}
	
	this.toString = function() {
		return this.getFaction() + " -> " + this.getRace() + " (" + this.getWorld() + " = " + this.getPopulationTotal() + ")";
	}
	
}

/**
 * World entry - any worlds without an entry don't have any atmosphere, ocean or natural life.
 * 
 * @param wikiname the name on the wiki
 * @param name the regular name
 * @param atmosphere a number 0-4 depicting the atmosphere type I-IV = 1-4 or 0 (none)
 * @param ocean a boolean, true if the world has an ocean
 * @param natLife a boolean, true if the world has natural life
 * @param zones the number of zones
 * @param image the image of the world
 */
function World(wikiname, name, atmosphere, ocean, natLife, zones, image) {

	this.wiki = wikiname;
	this.getWikiName = function() {
		return this.wiki;
	}

	this.worldName = name;
	this.getWorldName = function() {
		return this.worldName;
	}

	this.atm = atmosphere;
	this.getAtmosphere = function() {
		return this.atm;
	}

	this.water = ocean;
	this.getOcean = function() {
		return this.water;
	}

	this.life = natLife;
	this.getNaturalLife = function() {
		return this.life;
	}

	this.size = zones;
	this.getNumberOfZones = function() {
		return this.size;
	}

	this.img = image;
	this.getImage = function() {
		return this.img;
	}

	this.toString = function() {
		return this.getWikiName() + " -> " + this.getWorldName() + " (" + this.getAtmosphere() + ", " + this.getOcean() + ", " + this.getNaturalLife() + ", " + this.getNumberOfZones() + ")";
	}
	
}

/**
 * Race entry
 * 
 * @param wikiname the name on the wiki
 * @param plural the plural name of the race
 * @param highfec true if the population has the High Fecundity racial trait
 * @param highfer true if the population has the High Fertility racial trait
 * @param aquatic true if the population has the Aquatic racial trait
 * @param cyborg true if the population has the Cyborg racial trait
 * @param image the image of the race
 */
function Race(wikiname, plural, highfec, highfer, aquatic, cyborg, image) {

	this.wiki = wikiname;
	this.getWikiName = function() {
		return this.wiki;
	}
	
	this.plur = plural;
	this.getPlural = function() {
		return this.plur;
	}
	
	this.fecundity = highfec;
	this.getFecundity = function() {
		return this.fecundity;
	}
	
	this.fertility = highfer;
	this.getFertility = function() {
		return this.fertility;
	}

	this.aqua = aquatic;
	this.getAquatic = function() {
		return this.aqua;
	}

	this.cyb = cyborg;
	this.getCyborg = function() {
		return this.cyb;
	}
	
	this.img = image;
	this.getImage = function() {
		return this.img;
	}
	
	this.toString = function() {
		return this.getWikiName() + " -> " + this.getPlural() + " ( " + this.getFecundity() + ", " + this.getFertility() + ", " + this.getAquatic() + ", " + this.getCyborg() + ")";
	}
}
